﻿<%@ Page Title="Online Help" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="Registries_Cohorts.aspx.cs" Inherits="VIRP_WEB.Help.Registries_Cohorts" %>

<asp:Content ID="Content2" ContentPlaceHolderID="HeadContent" runat="server">
    <style>
        SPAN.searchword {
            background-color: yellow;
        }

        table tr {
            vertical-align: top;
        }

        table th {
            text-align: left;
        }

        img.HelpImage {
            border: solid 2px white;
            margin-left: 0.5in;
        }

        div.SectionDivider {
            padding-left: 0.5in;
            padding-bottom: .25in;
        }
    </style>
    <script src="../Scripts/TextHighlite.js" type="text/javascript"></script>
</asp:Content>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" runat="server">
    <h2 class="western">Creating a Registry</h2>
    <div class="SectionDivider">
        <p>The flow diagram for adding a Registry is shown below.</p>
        <img class="HelpImage" src="images/UserGuide3_html_m4485636c.png" width="624" height="76">
        <h3 class="western">1.1.Add a Registry</h3>
        <p>Step 1:	Login to the VIRP system by using the VA credentials    </p>
        <p>Step 2: Select the Cohorts menu item from the top menu</p>
        <p>Step 3: Click on &ldquo;Add New Registry&rdquo;</p>
        <p>Step 4: Fill in the details from the worksheet for the &lsquo;Registry Info&rsquo;, &lsquo;Contact Info&rsquo; and &lsquo;Schedule Info&rsquo;    </p>
        <p>Registry Info: Fill in the Registry Name, Abbreviation and Description    </p>
        <img class="HelpImage" src="images/UserGuide3_html_3b200e8a.png" width="423" height="199">
        <p>Contact Info: Select the &lsquo;Registry Owner&rsquo;, &lsquo;Registry Administrator&rsquo; and &lsquo;Support Contact&rsquo;    </p>
        <img class="HelpImage" src="images/UserGuide3_html_44dc3c7a.png" width="402" height="183">
        <p>If the User is not visible in the drop down as an existing user in Registry, click on the &lsquo;New User&rsquo; button to search for the user by &lsquo;Last Name&rsquo; and/or &lsquo;First Name&rsquo; add the user to the Registry from the VA active directory users.    </p>
        <img class="HelpImage" src="images/UserGuide3_html_3bc14319.png" width="387" height="195">
        <p>Schedule Info: Fill in the Schedule information for adding referrals.    </p>
        <p>The Schedule information is used by the Extract, Transform and Load (ETL) processes to extract data from the CDW database and populate the Registry.  The Schedule time can also be defined.   </p>
        <img class="HelpImage" src="images/UserGuide3_html_m7dd46e7d.png" width="405" height="244">
        <p>Step 5:	Click on &lsquo;Save&rsquo; to add an Registry</p>
    </div>
    <h3 class="western">2.Define Cohort criteria and Framework Data    </h3>
    <div class="SectionDivider">
        <p>Once a Registry is created, the Administrator defines the Cohort criteria for the ETL processes and the Framework data to be imported into the Registry. The criteria and the data to be imported will be available as a part of the worksheet filled in for creating a Registry.     </p>
        <p>Step 1:	Click on the &lsquo;Cohorts&rsquo; menu item from the top menu    </p>
        <p>Step 2: Select the Registry by clicking on the Name of the Registry created    </p>
        <p>Step 3: Define the Cohort Criteria for the Registry</p>
        <p>Select &lsquo;Cohort Criteria&rsquo; from left menu (if display is not &lsquo;Cohort Criteria&rsquo;).    </p>
        <p>Use the worksheet to select from the Available Categories and Add Selected.    </p>
        <p style="margin-left: 0.5in">Select the Criteria from the Selected Categories and toggle the check boxes to select the option for the criteria, and click on the Save button to save the Cohort Criteria.    </p>
        <img class="HelpImage" src="images/UserGuide3_html_6a64aefd.png" width="480" height="344">
        <p>Step 4:	Define the Framework Data for the Registry</p>
        <p>Select &lsquo;Framework Data&rsquo; from left menu items.</p>
        <p>Use the worksheet to select from the Available Categories and Add Selected.    </p>
        <p style="margin-left: 0.5in">Select tables from the Selected Categories and toggle the check boxes to select the option.     </p>
        <p>Click on Save to save the Framework Data tables citeria for import to the Registry.    </p>
        <img class="HelpImage" src="images/UserGuide3_html_m74ce42bc.png" width="484" height="305">
        <p>The defined Cohort criteria and the Framework data will be used by the ETL processes to import Patient information and respective Framwork data from the CDW database and populate the Registry with Referrals for the patients.    </p>
    </div>
    <h3 class="western">3.Add User Defined Fields</h3>
    <div class="SectionDivider">
        <p>The VIRP framework allows the Registry Administrator to add upto 10 User Defined Fields for capture of data for a Referral.  Follow these steps to add the User Defined Fields.     </p>
        <img class="HelpImage" src="images/UserGuide3_html_m591c5d3e.png" width="445" height="276">
        <p>Step 1: Select the Registry from the &lsquo;Cohorts&rsquo; menu from the top menu items    </p>
        <p>Step 2. Click on the &lsquo;User Defined Fields&rsquo; menu from the left menu items.    </p>
        <p style="margin-left: 0.5in">If any User Defined fields are already existing they will be displayed  </p>
        <p>Step 3: Click on &lsquo;Add New Field&rsquo; to add a new User Defined Field    </p>
        <p>Step 4: Fill in the Name, Code (Numeric value) and Description</p>
        <p>Step 5: Click on Save to save the User Defined Field</p>
        <img class="HelpImage" src="images/UserGuide3_html_m4cbfdfa7.png" width="455" height="191">
    </div>
    <h3 class="western">4.Creating Workstream and Activities</h3>
    <div class="SectionDivider">
        <p>The VIRP framework allows the Registry Administrator to create Workstreams with Activities  which is a workflow that can be initiated at the time of creating a Referral or added to a Referral. Status of each of the Activity in the Workstream can be monitored and tracked in the VIRP framework.     </p>
        <p>The steps to add a Workstream to Registry are listed below.</p>
        <p>Step 1:	Click on &lsquo;Cohorts&rsquo; and selected the Registry from the list of Registries      </p>
        <p>Step 2: Click on &lsquo;Workstream&rsquo; from the left menu items</p>
        <img class="HelpImage" src="images/UserGuide3_html_m28dd22a6.png" width="390" height="202">
        <p>The list of available Workstreams are displayed</p>
        <p>Step 3: Click on &lsquo;Add New Workstream&rsquo; to add a new Workstream.    </p>
        <img class="HelpImage" src="images/UserGuide3_html_3b1cdfd1.png" width="432" height="234">
        <p>Step 5:	Fill in the values for Name, Code, Sort Order and Description  </p>
        <p style="margin-left: 0.5in; text-indent: -0.5in">Step 6:	Select &lsquo;Automatically Created&rsquo; if you want to Workstream for a Referral to be created when a Referral is added either through the ETLs or manually.     </p>
        <p style="margin-left: 0.5in; text-indent: -0.5in">Step 7:	Click on &lsquo;Save&rsquo; to save the Workstream     </p>
        <p style="margin-left: 0.5in; text-indent: -0.5in">The steps to add  Activities for a Workstream are listed below.    </p>
        <p style="margin-left: 0.5in; text-indent: -0.5in">Step 1:	Select &lsquo;Activities&rsquo; from the left menu items     </p>
        <p style="margin-left: 0.5in; text-indent: -0.5in">All activities defined in the Registry are listed.    </p>
        <img class="HelpImage" src="images/UserGuide3_html_m61b3237c.png" width="446" height="302">
        <p style="margin-left: 0.5in; text-indent: -0.5in">Step 2: Select &lsquo;Add New Activity&rsquo; to add a Activity     </p>
        <img class="HelpImage" src="images/UserGuide3_html_12979e34.png" width="471" height="285">
        <p style="margin-left: 0.5in; text-indent: -0.5in">Step 3:	Select a Workstream and define a Name, Code, Sort Order and Description     </p>
        <p style="margin-left: 0.5in; text-indent: -0.5in">Step 4:	Select &lsquo;Automatically Created&rsquo; to initiate the Activity when the Workstream is created     </p>
        <p style="margin-left: 0.5in; text-indent: -0.5in">Step 5:	 Click on &lsquo;Save&rsquo; to save the Activity for the Workstream     </p>
        <p>For adding additional activities for the Workstream, repeat the steps to add the Activity.     </p>
    </div>

</asp:Content>
